function x=RandStdNormT(zlow, zhigh)
%	RANDSTDNORM - x=RandStdNormT(zlow, zhigh)
%	Random draw from truncated standard normal distribution
%	Note: the code has various tests to handle cases where machine precision is an issue.
if zlow==-inf & zhigh==inf;	%	no truncation
	x = randn(1);
	return;
end;
PROBNLIMIT = 6;	%	Above or below six standard deviations, we've lost machine precision
if zlow>PROBNLIMIT & (isinf(zhigh) | zhigh>PROBNLIMIT)
	x = zlow + 100*eps;	%	Set the draw slightly inside the lower limit
elseif zhigh<-PROBNLIMIT & (isinf(zlow) | zlow<-PROBNLIMIT)
	x = zhigh - 100*eps;	%	Set the draw slightly inside the upper limit
else
	if isinf(zlow)
		plow = 0;
	else
		plow = normcdfScalar(zlow);
	end
	if isinf(zhigh)
		phigh = 1;
	else
		phigh = normcdfScalar(zhigh);
	end;
	if plow==phigh
		disp('RandStdNormT. Error.');
		pause;
	end
	p = plow + rand(1)*(phigh-plow);
	switch p
		case 1
			x = zlow + 100*eps;
		case 0
			x = zlow - 100*eps;
		otherwise
			x = norminvScalar(p);
			% 	   x = norminv(p);
	end
	x = min(max(x,zlow),zhigh);
end
if ~isfinite(x)
	disp(['RandStdNormT returning non-finite x=' num2str(x)]);
	disp(sprintf('zlow=%25.15g\tzhigh=%25.15g',zlow,zhigh));
	disp(sprintf('plow=%25.15g\tphigh=%25.15g',plow,phigh));
	disp(sprintf('p=%25.15g',p));
	error('aborting');
end	